/*
 * HAL-E for the skyport competition (March 2013, by JustBurn & Kepler)
 *
 * Huggable Adorable Lovebot - EXTERMINATE
 * The lovechild of HAL and a Dalek.
 *
 * He got the good looks from HAL but the intelligence from a Dalek
 */

var max_mine_distance = 12;	// > 0     : Maximum mine distance, ignores mining if too far
var courage_movement = 0.33;	// 0.0~1.0 : Courage to take movement when enemies are in range
var courage_resource = 0.00;	// 0.0~1.0 : Courage to take resource when enemies are in range

var skyport = require('./skyport_API.js');
if(process.argv.length != 3) {
	console.log("Usage: node elretardo.js name_of_the_bot");
	process.exit();
}
var myname = process.argv[2];
function net_got_connection()
{
	console.log("* Connection, sending handshake...");
	connection.send_handshake(myname);
}
function net_got_handshake()
{
	console.log("* Handshake");
}
function net_got_error(message)
{
	console.log("* Error: '" + message + "'");
}
var directions = ["up", "right-up", "right-down", "down", "left-down", "left-up"];
var map_p = [];
var map_jmax = 0;
var map_kmax = 0;
var smaps = [];
var gplayers = null;
var pri_weapon = "laser";
var sec_weapon = "droid";
var laser_dist_list =  [0, 5, 6, 7];
var mortar_dist_list = [0, 2, 3, 4];
var droid_dist_list =  [0, 3, 4, 5];
var laser_atk_list =  [0, 16, 18, 22];
var mortar_atk_list = [0, 20, 20, 25];
var droid_atk_list =  [0, 22, 24, 26];
var resource_tier_list = [0, 4, 5, 9999];
var laser_resource = 0;
var mortar_resource = 0;
var droid_resource = 0;
var last_mine = ' ';
var last_upgrade_name = "none";
var last_upgrade_level = 1;

function debug_log(debugmsg)
{
	console.log("$ " + debugmsg);
}

function trace_log(funcname)
{
	console.log("! " + funcname + "()");
}

// Perform cloning of an object
function clone_obj(obj)
{
	if ((obj == null) || (typeof obj != "object")) return obj;

	if (obj instanceof Array) {
		var copy = [];
		var len = obj.length;
		for (var i=0; i<len; i++) copy[i] = clone_obj(obj[i]);
		return copy;
	}

	if (obj instanceof Object) {
		var copy = {};
		for (var attr in obj) {
			if (obj.hasOwnProperty(attr)) copy[attr] = clone_obj(obj[attr]);
		}
		return copy;
	}

	console.log("!!! Error while cloning obj: " + typeof obj + " type");
	return null;
}

// Calculate distance of 2 points along the ground
// Return: distance
function hexa_distance(j1, k1, j2, k2)
{
	trace_log("hexa_distance");
	var l1 = k1 - j1;
	var l2 = k2 - j2;
	return Math.max(Math.abs(j2 - j1), Math.abs(k2 - k1), Math.abs(l2 - l1));
}

// Calculate if 2 points are aligned and return direction or "none"
// Return: direction
function hexa_aligned_dir(j1, k1, j2, k2)
{
	trace_log("hexa_aligned_dir");
	if (j1 == j2) {
		if (k1 >= k2) return "left-up";
		else return "right-down";
	}
	else if (k1 == k2) {
		if (j1 >= j2) return "right-up";
		else return "left-down";
	}
	else if ((k1-k2) == (j1-j2)) {
		if (j1 >= j2) return "up";
		else return "down";
	}
	else return "none";
}

// Calculate up to 2 movements needed to align 2 points
// Return: list of movements | null
function hexa_toalign_pos(j1, k1, j2, k2)
{
	trace_log("hexa_toalign_pos");
	var dj = Math.abs(j2 - j1);
	var dk = Math.abs(k2 - k1);
	var dmin = Math.min(dj, dk);
	if ((dmin < -2) || (dmin > 2)) return null;
	if (dmin == 0) return [];
	if (dmin == dj) {
		switch (j2 - j1) {
		case  2: return ["left-down","left-down"];
		case  1: return ["left-down"];
		case -1: return ["right-up"];
		case -2: return ["right-up","right-up"];
		}
	}
	if (dmin == dk) {
		switch (k2 - k1) {
		case  2: return ["right-down","right-down"];
		case  1: return ["right-down"];
		case -1: return ["left-up"];
		case -2: return ["left-up","left-up"];
		}
	}
}

// Check if a cell is passable and no player is over it
// Return: boolean
function map_passable(jt, kt)
{
	if (map_p[jt][kt] == false) return false;
	for (var p=1; p<gplayers.length; p++) {
		if ((gplayers["j"] == jt) && (gplayers["k"] == kt)) return false;
	}
	return true;
}


// Simulate player movements
// Return: "j", "k" and "v" (valid)
function sim_player_movements(pj, pk, mv_list, maxmovements)
{
	trace_log("sim_player_movements");
	if (mv_list == null) {
		console.log("!!! Empty movement list in simulation");
		return {"v":false, "j":pj, "k":pk};
	}
	var valid = true;
	for (var i=0; i<mv_list.length; i++) {
		if (i == maxmovements) break;
		if (mv_list[i] == "down") {
			if (sim_player_movements_cell(pj+1, pk+1) == true) { pj++; pk++; }
			else valid = false;
		}
		else if (mv_list[i] == "left-down") {
			if (sim_player_movements_cell(pj+1, pk) == true) pj++;
			else valid = false;
		}
		else if (mv_list[i] == "left-up") {
			if (sim_player_movements_cell(pj, pk-1) == true) pk--;
			else valid = false;
		}
		else if (mv_list[i] == "up") {
			if (sim_player_movements_cell(pj-1, pk-1) == true) { pj--; pk--; }
			else valid = false;
		}
		else if (mv_list[i] == "right-up") {
			if (sim_player_movements_cell(pj-1, pk) == true) pj--;
			else valid = false;
		}
		else if (mv_list[i] == "right-down") {
			if (sim_player_movements_cell(pj, pk+1) == true) pk++;
			else valid = false;
		}
	}
	return {"v":valid, "j":pj, "k":pk};
}
function sim_player_movements_cell(jt, kt)
{
	if ((jt < 0) || (jt >= map_jmax)) return false;
	if ((kt < 0) || (kt >= map_kmax)) return false;
	return map_passable(jt, kt);
}

// Check if a player has a specific weapon
// Return: slot | null
function weapon_slot(player, weapon)
{
	trace_log("weapon_slot");
	if (player["primary-weapon"]["name"] == weapon) return "primary-weapon";
	if (player["secondary-weapon"]["name"] == weapon) return "secondary-weapon";
	return null;
}

// Build map scan out of 1 point (slooow!)
// Return: "j", "k" and "m" (scan map)
function map_scan(jp, kp, map)
{
	trace_log("map_scan");
	var smap = [];
	for (var j=0; j<map_jmax; j++) {
		smap[j] = [];
		for (var k=0; k<map_kmax; k++) {
			smap[j][k] = map_p[j][k] ? 9999 : -1;
		}
	}
	smap[jp][kp] = 9999;
	map_scan_cell(map, smap, jp, kp, 0);
	return {"j":jp, "k":kp, "m":smap};
}
function map_scan_cell(map, smap, jp, kp, cellno)
{
	if ((jp < 0) || (jp >= map_jmax)) return;
	if ((kp < 0) || (kp >= map_kmax)) return;
	if (cellno >= smap[jp][kp]) return;
	smap[jp][kp] = cellno++;
	map_scan_cell(map, smap, jp-1, kp-1, cellno);
	map_scan_cell(map, smap, jp-1, kp  , cellno);
	map_scan_cell(map, smap, jp  , kp+1, cellno);
	map_scan_cell(map, smap, jp+1, kp+1, cellno);
	map_scan_cell(map, smap, jp+1, kp  , cellno);
	map_scan_cell(map, smap, jp  , kp-1, cellno);
}

// Find nearest tile (slow too!)
// Return: "j", "k" and "d" (distance)
function nearest_tile(map, smap, tileid)
{
	trace_log("nearest_tile");
	var nearestdist = 9999;
	var fj = -1; fk = -1;
	for (var j=0; j<map_jmax; j++) {
		for (var k=0; k<map_kmax; k++) {
			var tiledist = smap["m"][j][k];
			if ((map["data"][j][k] == tileid) && (tiledist < nearestdist)) {
				nearestdist = tiledist;
				fj = j; fk = k;
			}
		}
	}
	return {"j":fj, "k":fk, "d":nearestdist};
}

// Trace player movements
// Return: list of movements | null
function trace_movements(map, smap, jt, kt, maxmovements)
{
	trace_log("trace_movements");
	var tiledist = smap["m"][jt][kt];
	if ((tiledist == -1) || (tiledist == 9999)) return null;
	var movs = [];
	while (tiledist--) {
		if (trace_movements_cell(smap, jt-1, kt-1) === tiledist) {
			movs.push("down"); jt--; kt--;
		}
		else if (trace_movements_cell(smap, jt-1, kt) === tiledist) {
			movs.push("left-down"); jt--;
		}
		else if (trace_movements_cell(smap, jt, kt+1) === tiledist) {
			movs.push("left-up"); kt++;
		}
		else if (trace_movements_cell(smap, jt+1, kt+1) === tiledist) {
			movs.push("up"); jt++; kt++;
		}
		else if (trace_movements_cell(smap, jt+1, kt) === tiledist) {
			movs.push("right-up"); jt++;
		}
		else if (trace_movements_cell(smap, jt, kt-1) === tiledist) {
			movs.push("right-down"); kt--;
		}
		else {
			console.log("!!! Internal error on trace movement");
		}
	}
	return movs.reverse().slice(0, maxmovements);
}
function trace_movements_cell(smap, jt, kt)
{
	if ((jt < 0) || (jt >= map_jmax)) return 9999;
	if ((kt < 0) || (kt >= map_kmax)) return 9999;
	return smap["m"][jt][kt];
}

// Check if the enemy has range of attack after player do certain moves
// Return: boolean
function enemy_has_range(map, smaps, players, mmov)
{
	var sppos = sim_player_movements(players[0]["j"], players[0]["k"], mmov, 3);
	if (sppos["v"]) {
		var nplayer = clone_obj(players[0]);
		nplayer["j"] = sppos["j"];
		nplayer["k"] = sppos["k"];
		for (var p=1; p<players.length; p++) {
			if (action_attack(map, smaps[p], players[p], nplayer) != null) return true;
		}
	}
	return false;
}

// Try to avoid AoE but shoot if can't anyway
// Return: "m": list of movements, "a": attack direction
function avoid_aoe_mortar(jp, kp, jt, kt)
{
	trace_log("avoid_aoe_mortar");
	var mmov = ["none"];
	for (var trydir=0; trydir<directions.length; trydir++) {
		mmov[0] = directions[trydir];
		var sppos = sim_player_movements(jp, kp, mmov, 1);
		if (sppos["v"]) {
			var avar = (jt - sppos["j"]) + "," + (kt - sppos["k"]);
			if (hexa_distance(sppos["j"], sppos["k"], jt, kt) == 2) return {"m":mmov, "a":avar};
		}
	}
	// Can't avoid AoE
	var avar = (jt - jp) + "," + (kt - kp);
	return {"m":[], "a":avar};
}
function avoid_aoe_droid(jp, kp, jt, kt)
{
	trace_log("avoid_aoe_droid");
	var mmov = ["none"];
	for (var trydir=0; trydir<directions.length; trydir++) {
		mmov[0] = directions[trydir];
		var opdir = directions[(trydir + 3) % 6];
		var sppos = sim_player_movements(jp, kp, mmov, 1);
		if (sppos["v"]) {
			var adir = hexa_aligned_dir(jp, kp, jt, kt);
			if (hexa_distance(sppos["j"], sppos["k"], jt, kt) == 2) return {"m":mmov, "a":[opdir, adir]};
		}
	}
	// Can't avoid AoE
	var adir = hexa_aligned_dir(jp, kp, jt, kt);
	return {"m":[], "a":[adir]};
}

// Check if a player has laser range of attack
// Return: "m": list of movements, "a": attack direction | null
function range_laser(map, smap, jt, kt, level)
{
	trace_log("range_laser");
	var pldist, mmov = [];
	var adir = hexa_aligned_dir(smap["j"], smap["k"], jt, kt);
	if (adir == "none") {
		mmov = hexa_toalign_pos(smap["j"], smap["k"], jt, kt);
		if (mmov == null) return null;
		debug_log("LaserMov=" + mmov.join());
		var sppos = sim_player_movements(smap["j"], smap["k"], mmov, 2);
		if (!sppos["v"]) return null;
		pldist = hexa_distance(sppos["j"], sppos["k"], jt, kt);
		debug_log("LaserSim=" + smap["j"] + "x" + smap["k"] + "  " + sppos["j"] + "x" + sppos["k"]);
		debug_log("LaserDist=" + pldist);
		if (pldist > laser_dist_list[level]) return null;
		adir = hexa_aligned_dir(sppos["j"], sppos["k"], jt, kt);
		debug_log("LaserPos=" + sppos["j"] + "x" + sppos["k"] + "  " + jt + "x" + kt);
		if (adir == "none") {
			console.log("!!! Internal error on range laser");
			return null;
		}
	} else {
		pldist = hexa_distance(smap["j"], smap["k"], jt, kt);
		debug_log("LaserDisT=" + pldist);
		if (pldist > laser_dist_list[level]) return null;
		debug_log("LaserPos=" + smap["j"] + "x" + smap["k"] + "  " + jt + "x" + kt);
	}
	debug_log("LaserAlign=" + adir);
	for (var i=0; i<pldist; i++) {
		if (map["data"][jt][kt] == 'O') {
			debug_log("Found a rock in the way");
			return null;
		}
		if (adir == "down") { jt--; kt--; }
		if (adir == "left-down") { jt--; }
		if (adir == "left-up") { kt++; }
		if (adir == "up") { jt++; kt++; }
		if (adir == "right-up") { jt++; }
		if (adir == "right-down") { kt--; }
	}
	return {"m":mmov, "a":adir};
}

// Check if a player has mortar range of attack
// Return: "m": list of movements, "a": attack position | null
function range_mortar(map, smap, jt, kt, level)
{
	trace_log("range_mortar");
	var mmov = [];
	var jp = smap["j"], kp = smap["k"];
	var pldist = hexa_distance(jp, kp, jt, kt);
	var avar = (jt - jp) + "," + (kt - kp);
	if (pldist > (mortar_dist_list[level] + 2)) return null;
	else if (pldist <= 1) return avoid_aoe_mortar(jp, kp, jt, kt);
	else if (pldist <= mortar_dist_list[level]) return {"m":mmov, "a":avar};
	else {
		var nmovs = (mortar_dist_list[level] + 2) - pldist;
		mmov = trace_movements(map, smap, jt, kt, nmovs);
		if (mmov == null) mmov = [];
		var sppos = sim_player_movements(jp, kp, mmov, 2);
		var pldist2 = hexa_distance(sppos["j"], sppos["k"], jt, kt);		
		if (pldist2 < pldist) {
			pldist = pldist2;
			jp = sppos["j"];
			kp = sppos["k"];
		}
	}
	var avar = (jt - jp) + "," + (kt - kp);
	if (pldist <= 1) return avoid_aoe_mortar(jp, kp, jt, kt);
	else if (pldist <= mortar_dist_list[level]) return {"m":mmov, "a":avar};
	return null;
}

// Check if a player has droid range of attack
// Return: "m": list of movements, "a": attack list | null
function range_droid(map, smap, jt, kt, level)
{
	trace_log("range_droid");
	var mmov = [], dmov = [];
	var jp = smap["j"], kp = smap["k"];
	var pldist = hexa_distance(jp, kp, jt, kt);
	if (pldist > (droid_dist_list[level] + 2)) return null;
	else if (pldist <= 1) return avoid_aoe_droid(jp, kp, jt, kt);
	else if (pldist <= droid_dist_list[level]) {
		var distnum = smap["m"][jt][kt];
		if (distnum != pldist) return null;
		dmov = trace_movements(map, smap, jt, kt, droid_dist_list[level]);
		if (dmov == null) dmov = [];
		return {"m":mmov, "a":dmov};
	}
	else {
		var nmovs = (droid_dist_list[level] + 2) - pldist;
		mmov = trace_movements(map, smap, jt, kt, nmovs);
		if (mmov == null) mmov = [];
		var sppos = sim_player_movements(jp, kp, mmov, 2);
		pldist2 = hexa_distance(sppos["j"], sppos["k"], jt, kt);
		if (pldist2 < pldist) {
			pldist = pldist2;
			jp = sppos["j"];
			kp = sppos["k"];
		}
	}
	if (pldist <= 1) return avoid_aoe_droid(jp, kp, jt, kt);
	else if (pldist <= droid_dist_list[level]) {
		var nsmap = map_scan(jp, kp, map);
		var distnum = nsmap["m"][jt][kt];
		if (distnum != pldist) return null;
		dmov = trace_movements(map, nsmap, jt, kt, droid_dist_list[level]);
		if (dmov == null) dmov = [];
		return {"m":mmov, "a":dmov};
	}
	return null;
}

// Action: Attack
// Return: "w": weapon, "m": list of moves, "s": attack score, "a": attack action | null
function action_attack(map, smap, splayer, tplayer)
{
	trace_log("action_attack");
	var laser_mov = null, mortar_mov = null, droid_mov = null;
	var laser_atk = 0, mortar_atk = 0, droid_atk = 0;
	debug_log("Statistics attack " + splayer["name"] + "->" + tplayer["name"]);
	if (map["data"][splayer["j"]][splayer["k"]] == 'S') return null;
	if (map["data"][tplayer["j"]][tplayer["k"]] == 'S') return null;
	if (tplayer["health"] <= 0) return null;
	var weapon = weapon_slot(splayer, "laser");
	if (weapon != null) {
		var level = splayer[weapon]["level"];
		debug_log("Laser Lvl " + level);
		laser_mov = range_laser(map, smap, tplayer["j"], tplayer["k"], level);
		if (laser_mov != null) {
			var bonus = Math.max(0, 2 - laser_mov["m"].length);
			laser_atk = laser_atk_list[level];
			laser_atk += bonus * (0.2 * laser_atk);
		}
	}
	weapon = weapon_slot(splayer, "mortar");
	if (weapon != null) {
		var level = splayer[weapon]["level"];
		debug_log("Mortar Lvl " + level);
		mortar_mov = range_mortar(map, smap, tplayer["j"], tplayer["k"], level);
		if (mortar_mov != null) {
			var bonus = Math.max(0, 2 - mortar_mov["m"].length);
			mortar_atk = mortar_atk_list[level];
			mortar_atk += bonus * (0.2 * mortar_atk);
		}
	}
	weapon = weapon_slot(splayer, "droid");
	if (weapon != null) {
		var level = splayer[weapon]["level"];
		debug_log("Droid Lvl " + level);
		droid_mov = range_droid(map, smap, tplayer["j"], tplayer["k"], level);
		if (droid_mov != null) {
			var bonus = Math.max(0, 2 - droid_mov["m"].length);
			droid_atk = droid_atk_list[level];
			droid_atk += bonus * (0.2 * droid_atk);
		}
	}
	debug_log("Laser Atk  =" + laser_atk);
	debug_log("Mortar Atk =" + mortar_atk);
	debug_log("Droid Atk  =" + droid_atk);
	var wamax = Math.max(laser_atk, mortar_atk, droid_atk);
	if (wamax <= 0) return null;
	else if (wamax == droid_atk) return {"w":"droid", "m":droid_mov["m"], "s":droid_atk, "a":droid_mov["a"]};
	else if (wamax == mortar_atk) return {"w":"mortar", "m":mortar_mov["m"], "s":mortar_atk, "a":mortar_mov["a"]};
	else if (wamax == laser_atk) return {"w":"laser", "m":laser_mov["m"], "s":laser_atk, "a":laser_mov["a"]};
	return null;
}

// Action: Run away
// Return: list of movements | null
function action_runaway(map, tsmap, splayer, tplayer)
{
	trace_log("action_runaway");
	var jt = splayer["j"];
	var kt = splayer["k"];
	var tiledist = tsmap["m"][jt][kt];
	var targetdist = tiledist + 3;
	if ((tiledist == -1) || (tiledist == 9999)) return null;
	return action_runaway_cell(tsmap, [], jt, kt, tiledist, targetdist);
}
function action_runaway_cell(tsmap, movs, jt, kt, tiledist, targetdist)
{
	if (tiledist == targetdist) return movs;
	tiledist++;
	var nmovs = movs.slice(0, movs.length);
	if (trace_movements_cell(tsmap, jt-1, kt-1) === tiledist) {
		nmovs.push("up");
		var rmovs = action_runaway_cell(tsmap, nmovs, jt-1, kt-1, tiledist);
		if (rmovs != null) return rmovs;
	}
	if (trace_movements_cell(tsmap, jt-1, kt) === tiledist) {
		nmovs.push("right-up");
		var rmovs = action_runaway_cell(tsmap, nmovs, jt-1, kt, tiledist);
		if (rmovs != null) return rmovs;
	}
	if (trace_movements_cell(tsmap, jt, kt+1) === tiledist) {
		nmovs.push("right-down"); kt--;
		var rmovs = action_runaway_cell(tsmap, nmovs, jt, kt+1, tiledist);
		if (rmovs != null) return rmovs;
	}
	if (trace_movements_cell(tsmap, jt+1, kt+1) === tiledist) {
		nmovs.push("down");
		var rmovs = action_runaway_cell(tsmap, nmovs, jt+1, kt+1, tiledist);
		if (rmovs != null) return rmovs;
	}
	if (trace_movements_cell(tsmap, jt+1, kt) === tiledist) {
		nmovs.push("left-down");
		var rmovs = action_runaway_cell(tsmap, nmovs, jt+1, kt, tiledist);
		if (rmovs != null) return rmovs;
	}
	if (trace_movements_cell(tsmap, jt, kt-1) === tiledist) {
		nmovs.push("left-up");
		var rmovs = action_runaway_cell(tsmap, nmovs, jt, kt-1, tiledist);
		if (rmovs != null) return rmovs;
	}
	return null;
}


// Perform: Attack
// Return true
function perform_attack(tplayer, atk)
{
	trace_log("perform_attack");
	console.log("] Attacking " + tplayer["name"] + " with " + atk["w"]);
	for (var i=0; i<atk["m"].length; i++) connection.move(atk["m"][i]);
	if (atk["w"] == "laser") {
		connection.attack_laser(atk["a"]);
		console.log("] Targeting " + atk["a"]);
	}
	if (atk["w"] == "mortar") {
		var avar = atk["a"].split(",");
		connection.attack_mortar(avar[0], avar[1]);
		console.log("] Targeting at " + avar[0] + "," + avar[1]);
	}
	if (atk["w"] == "droid") {
		connection.attack_droid(atk["a"]);
		console.log("] Droid commands: " + atk["a"].join());
	}
	return true;
}

// Perform: Run away
// Return true
function perform_runaway(tplayer, moves)
{
	trace_log("perform_runaway");
	console.log("] Running away from " + tplayer["name"]);
	for (var i=0; i<moves.length; i++) connection.move(moves[i]);
	return true;
}

// Perform: Mining and upgrade
// If moves is null, it will only perform upgrade
// Return true
function perform_mine_upgrade(splayer, map, moves, jt, kt, upgrade)
{
	trace_log("perform_mine_upgrade");
	var maxact = (upgrade == "none") ? 3 : 2;
	var wslot = weapon_slot(splayer, upgrade);
	if (wslot != null) {
		last_upgrade_name = upgrade;
		last_upgrade_level = splayer[wslot]["level"];
	}
	if (moves != null) {
		last_mine = map["data"][jt][kt];
		var maxmov = Math.min(moves.length, maxact);
		var minetype = "unknown (Unknown)";
		switch(last_mine) {
			case 'R': minetype = "rubidium (Laser)"; break;
			case 'E': minetype = "explosium (Mortar)"; break;
			case 'C': minetype = "scrap (Droid)"; break;
		}
		for (var i=0; i<maxmov; i++) connection.move(moves[i]);
		if (maxmov < maxact) {
			var minetimes = Math.min(2, maxact - maxmov);
			console.log("] Mining " + minetype + " x" + minetimes + " at " + jt + "," + kt);
			for (var i=0; i<minetimes; i++) connection.mine();
		} else {
			console.log("] Moving toward " + minetype + " at " + jt + "," + kt);
		}
	} else {
		console.log("] Preparing for upgrade");
	}
	if (upgrade != "none") {
		console.log("] Upgrading " + upgrade);
		connection.upgrade(upgrade);
	}
	return true;
}

// State 1: Attack enemy
function state_attack(map, smaps, players)
{
	var players_a = [];
	var players_e = [];
	// Analyze
	trace_log("STATE_ATTACK_analyze");
	for (var p=1; p<players.length; p++) {
		players_a[p] = action_attack(map, smaps[0], players[0], players[p]);
		players_e[p] = action_attack(map, smaps[p], players[p], players[0]);
	}
	// Attack
	trace_log("STATE_ATTACK_attack");
	var t_p = 0, t_s = 0;
	for (var p=1; p<players.length; p++) {
		if (players_a[p] != null) {
			if ((players_a[p]["s"] > t_s) ||
			   ((players_a[p]["s"] == t_s) && (players[p]["health"] < players[t_p]["health"]))) {
				t_p = p;
				t_s = players_a[p]["s"];
			}
		}
	}
	if ((t_p != 0) && (t_s != 0)) {
		if ((map["data"][players[0]["j"]][players[0]["k"]] == 'S') && (players_a[t_p]["m"].length == 0)) return null;
		return perform_attack(players[t_p], players_a[t_p]);
	}
	// Defend
	trace_log("STATE_ATTACK_defend");
	for (var p=1; p<players.length; p++) {
		if ((players_a[p] == null) && (players_e[p] != null)) {
			var mmov = action_runaway(map, smaps[p], players[0], players[p]);
			if (mmov == null) continue;
			return perform_runaway(players[p], mmov);
		}
	}
	trace_log("STATE_ATTACK_skip");
	return false;
}

// State 2: Collect resource
function state_resource(map, smaps, players)
{
	var pri_res = {"j":0, "k":0, "d":9999};
	var sec_res = {"j":0, "k":0, "d":9999};
	var jt, kt, wtile, upgrade = "none";
	trace_log("STATE_RESOURCE_primary");
	var pri_wa = players[0]["primary-weapon"]["name"];
	var pri_wl = players[0]["primary-weapon"]["level"];
	if (pri_wl <= 2) {
		if (pri_wa == "laser") {
			wtile = 'R';
			if (laser_resource >= resource_tier_list[pri_wl]) upgrade = "laser";
		}
		else if (pri_wa == "mortar") {
			wtile = 'E';
			if (mortar_resource >= resource_tier_list[pri_wl]) upgrade = "mortar";
		}
		else if (pri_wa == "droid") {
			wtile = 'C';
			if (droid_resource >= resource_tier_list[pri_wl]) upgrade = "droid";
		}
		pri_res = nearest_tile(map, smaps[0], wtile);
	}
	trace_log("STATE_RESOURCE_secondary");
	var sec_wa = players[0]["secondary-weapon"]["name"];
	var sec_wl = players[0]["secondary-weapon"]["level"];
	if (sec_wl <= 2) {
		if (sec_wa == "laser") {
			wtile = 'R';
			if (laser_resource >= resource_tier_list[sec_wl]) upgrade = "laser";
		}
		else if (sec_wa == "mortar") {
			wtile = 'E';
			if (mortar_resource >= resource_tier_list[sec_wl]) upgrade = "mortar";
		}
		else if (sec_wa == "droid") {
			wtile = 'C';
			if (droid_resource >= resource_tier_list[sec_wl]) upgrade = "droid";
		}
		sec_res = nearest_tile(map, smaps[0], wtile);
	}
	trace_log("STATE_RESOURCE_distance");
	var mindist = Math.min(pri_res["d"], sec_res["d"]);
	debug_log("Mine dist=" + mindist);
	if (upgrade != "none") {
		if (mindist > 9999) return perform_mine_upgrade(players[0], map, null, 0, 0, upgrade);
	} else {
		if (mindist > max_mine_distance) return false;
	}
	trace_log("STATE_RESOURCE_distance2");
	if (mindist == pri_res["d"]) {
		jt = pri_res["j"];
		kt = pri_res["k"];
	}
	else if (mindist == sec_res["d"]) {
		jt = sec_res["j"];
		kt = sec_res["k"];
	}
	trace_log("STATE_RESOURCE_trace");
	var mmov = trace_movements(map, smaps[0], jt, kt, 3);
	if ((mmov == null) && (!upgrade)) return false;
	else if (mmov != null) {
		if (Math.random() >= courage_resource) {
			if (enemy_has_range(map, smaps, players, mmov)) return false;
		}
	}
	return perform_mine_upgrade(players[0], map, mmov, jt, kt, upgrade);
}

// State 3: Chase enemy
function state_chase(map, smaps, players)
{
	var enemy_id = 0, enemy_score = 9999999;
	var atk = null;
	trace_log("STATE_CHASE_scoring");
	for (var p=1; p<players.length; p++) {
		var score = players[p]["score"] + players[p]["health"] * 5 + hexa_distance(players[0]["j"], players[0]["k"], players[p]["j"], players[p]["k"]) * 25;
		if (map["data"][players[p]["j"]][players[p]["k"]] == 'S') score = 9999999;
		debug_log("Engage score of " + players[p]["name"] + "=" + score);
		if (score < enemy_score) {
			enemy_score = score;
			enemy_id = p;
		}
	}
	trace_log("STATE_CHASE_engaging");
	if (enemy_id != 0) {
		console.log("] Engaging target " + players[enemy_id]["name"]);
		atk = action_attack(map, smaps[0], players[0], players[enemy_id]);
	}
	if (atk == null) {
		var mmov = trace_movements(map, smaps[0], players[enemy_id]["j"], players[enemy_id]["k"], 3);
		if ((mmov != null) && (mmov.length > 0)) {
			if (Math.random() >= courage_movement) {
				while (enemy_has_range(map, smaps, players, mmov)) {
					mmov = mmov.slice(0, mmov.length - 1);
					if (mmov.length == 0) break;
				}
			}
			if (mmov.length != 0) {
				console.log("] Target out of range, moving...");
				for (var i=0; i<mmov.length; i++) connection.move(mmov[i]);
				return true;
			} else {
				var mmov = action_runaway(map, smaps[enemy_id], players[0], players[enemy_id]);
				if (mmov != null) return perform_runaway(players[enemy_id], mmov);
			}
		}
	} else {
		if ((map["data"][players[0]["j"]][players[0]["k"]] == 'S') && (atk["m"].length == 0)) {
			var rdir, jp = players[0]["j"], kp = players[0]["k"];
			for (var t=0; t<36; t++) {
				rdir = directions[Math.floor(Math.random() * directions.length)];
				var sppos = sim_player_movements(players[0]["j"], players[0]["k"], [rdir], 1);
				if (sppos["v"]) break;
			}
			connection.move(rdir);	// Move away from spawn, try to still perform an attack
		}
		return perform_attack(atk);
	}
	console.log("] Moving randomly");
	for (var i=0; i<3; i++) {
		var rdir, jp = players[0]["j"], kp = players[0]["k"];
		for (var t=0; t<36; t++) {
			rdir = directions[Math.floor(Math.random() * directions.length)];
			var sppos = sim_player_movements(jp, kp, [rdir], 1);
			if (sppos["v"]) {
				jp = sppos["j"];
				kp = sppos["k"];
				break;
			}
			
		}
		connection.move(rdir);
	}
	return true;
}

function net_got_gamestart(map, players)
{
	var mortarpoints = 0;
	var laserpoints = 0;
	var droidpoints = 0;
	console.log("* Gamestart");
	map_p = [];
	map_jmax = map["j-length"];
	map_kmax = map["k-length"];
	for (var j=0; j<map_jmax; j++) {
		map_p[j] = [];
		for (var k=0; k<map_kmax; k++) {
			switch (map["data"][j][k]) {
			case 'E': map_p[j][k] = true; mortarpoints += 20; break;
			case 'R': map_p[j][k] = true; laserpoints += 20; break;
			case 'C': map_p[j][k] = true; droidpoints += 20; break;
			case 'O': map_p[j][k] = false; mortarpoints += 5; break;
			case 'V': map_p[j][k] = false; laserpoints++; break;
			case 'G': map_p[j][k] = true; droidpoints++; break;
			default: map_p[j][k] = false; break;
			}
		}
	}
	for (var k=0; k<map_kmax; k++) {
		var msgout = "";
		for (var j=0; j<map_jmax; j++) {
			msgout += map_p[j][k] ? "1" : "0";
		}
		console.log(msgout);
	}
	if ((mortarpoints <= laserpoints) && (mortarpoints <= droidpoints)) {
		pri_weapon = "laser"; sec_weapon = "droid";
	}
	else if ((laserpoints <= mortarpoints) && (laserpoints <= droidpoints)) {
		pri_weapon = "mortar"; sec_weapon = "droid";
	}
	else if ((droidpoints <= mortarpoints) && (droidpoints <= laserpoints)) {
		pri_weapon = "mortar"; sec_weapon = "laser";
	}
	console.log("Mortar: " + mortarpoints);
	console.log("Laser: " + laserpoints);
	console.log("Droid: " + droidpoints);
	console.log("Selected loadout: " + pri_weapon + " & " + sec_weapon);
	connection.send_loadout(pri_weapon, sec_weapon);
}
function net_got_gamestate(turn_number, map, players)
{
	console.log("* Turn " + turn_number + " from " + players[0]["name"]);
	if (players[0]["name"] == myname) {
		// Convert each player position into 2 nice integers
		var smaps = [];
		gplayers = players;
		trace_log("GAMESTATE_convert");
		for (var p=0; p<players.length; p++) {
			var playerpos = players[p]["position"].split(",");
			players[p]["j"] = parseInt(playerpos[0]); players[p]["k"] = parseInt(playerpos[1]);
			smaps[p] = map_scan(players[p]["j"], players[p]["k"], map);
		}
		trace_log("GAMESTATE_states");
		if (state_attack(map, smaps, players)) return;
		if (state_resource(map, smaps, players)) return;
		state_chase(map, smaps, players);
	}
}
function net_got_action(type, from, rest)
{
	if ((type === undefined) || (from === undefined)) {
		console.log("BUG IN SKYPORT.JS, PLEASE FIX ACTION DISPATCH");
		return;
	}
	if (from == myname) {
		if (type == "mine") {
			switch(last_mine) {
			case 'R': laser_resource++; break;
			case 'E': mortar_resource++; break;
			case 'C': droid_resource++; break;
			default: console.log("!!! Unknown last mine action"); break;
			}
		}
		else if (type == "upgrade") {
			if (last_upgrade_level >= 3) {
				console.log("!!! Invalid upgrade");
				return;
			}
			if (last_upgrade_name == "laser") laser_resource -= resource_tier_list[last_upgrade_level];
			else if (last_upgrade_name == "mortar") mortar_resource -= resource_tier_list[last_upgrade_level];
			else if (last_upgrade_name == "droid") droid_resource -= resource_tier_list[last_upgrade_level];
		}
	}
}
function net_got_endturn()
{
	console.log("* End turn");
}

connection = new skyport.SkyportConnection("localhost", 54321);
connection.on('connection', net_got_connection);
connection.on('handshake', net_got_handshake);
connection.on('gamestart', net_got_gamestart);
connection.on('gamestate', net_got_gamestate);
connection.on('action', net_got_action);
connection.on('error', net_got_error);
connection.on('endturn', net_got_endturn);
connection.connect();
